﻿
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.WebSockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace WebsocketSample_csharp
{
    class Program
    {
        private static readonly string endpoint = "Enter the endpoint shared with you on mail ";
        private static readonly string apikey = "Enter the key here";
        private static readonly ClientWebSocket ws = new ClientWebSocket();
        //private static Timer? timeoutTimer;

        static async Task Authenticate()
        {
            Console.WriteLine("Authenticating...");
            string message = "{\"MessageType\":\"Authenticate\",\"Password\":\"" + apikey + "\"}";
            await SendMessageAsync(message);
        }
        static async Task SubscribeRealtime()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "NIFTY-I";
            string Unsubscribe = "false";

            string message = $"{{\"MessageType\":\"SubscribeRealtime\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{InstrumentIdentifier}\",\"Unsubscribe\":{Unsubscribe}}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task SubscribeSnapshot()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "NIFTY-I";
            string Unsubscribe = "false";
            string periodicity = "MINUTE";
            int period = 1;
            string message = $"{{\"MessageType\":\"SubscribeSnapshot\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{InstrumentIdentifier}\",\"Periodicity\":\"{periodicity}\",\"Period\":{period},\"Unsubscribe\":\"{Unsubscribe}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetLastQuote()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "NIFTY-I";
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetLastQuote\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{InstrumentIdentifier}\",\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetLastQuoteShort()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "NIFTY-I";
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetLastQuoteShort\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{InstrumentIdentifier}\",\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetLastQuoteShortWithClose()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "NIFTY-I";
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetLastQuoteShortWithClose\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{InstrumentIdentifier}\",\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetLastQuoteArray()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "[{\"Value\":\"NIFTY-I\"},{\"Value\":\"BANKNIFTY-I\"}]";
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetLastQuoteArray\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifiers\":{InstrumentIdentifier},\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetLastQuoteArrayShort()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "[{\"Value\":\"NIFTY-I\"},{\"Value\":\"BANKNIFTY-I\"}]";
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetLastQuoteArrayShort\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifiers\":{InstrumentIdentifier},\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetLastQuoteArrayShortWithClose()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "[{\"Value\":\"NIFTY-I\"},{\"Value\":\"BANKNIFTY-I\"}]";
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetLastQuoteArrayShortWithClose\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifiers\":{InstrumentIdentifier},\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        
        static async Task GetSnapshot()
        {
            string exchangeName = "NFO";
            string instIdentifier = "[{\"Value\":\"NIFTY-I\"},{\"Value\":\"BANKNIFTY-I\"}]";
            string periodicity = "MINUTE";
            int period = 1;
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetSnapshot\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifiers\":{instIdentifier},\"Periodicity\":\"{periodicity}\",\"Period\":{period},\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }



        static async Task GetHistory()
        {
            string exchangeName = "NFO";
            string instIdentifier = "NIFTY-I";
            string periodicity = "MINUTE";
            int period = 1;
            // int  From = 1615919400;
            // int  To = 1621171693 ;
            int max = 10;
            string userTag = "User1";
            string isShortIdentifier = "false";
            string adjustSplits = "false";
            string message = $"{{\"MessageType\":\"GetHistory\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{instIdentifier}\",\"Periodicity\":\"{periodicity}\",\"Period\":{period},\"Max\":{max},\"UserTag\":\"{userTag}\",\"isShortIdentifier\":\"{isShortIdentifier}\",\"AdjustSplits\":\"{adjustSplits}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetInstrumentsOnSearch()
        {
            string ExchangeName = "NFO";
            string Search = "NIFTY";
            // string Product = "NIFTY"  ;
            // string InstrumentType = "FUTIDX";
            // string OptionType = "PE";
            // string Expiry = "25APR2024";
            // int StrikePrice = 10000 ;
            // string OnlyActive = "TRUE";
            string message = $"{{\"MessageType\":\"GetInstrumentsOnSearch\",\"Exchange\":\"{ExchangeName}\",\"Search\":\"{Search}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetInstruments()
        {
            string ExchangeName = "NFO";
            //string InstrumentType = "FUTSTK";
            //string FUTCUR, FUTCOM, etc.
            string Product = "BANKNIFTY";
            //string OptionType = "PE"		    
            //string Expiry = "29APR2021"	    
            //int StrikePrice = 10000	    	
            //string OnlyActive = "TRUE"   		
            string message = $"{{\"MessageType\":\"GetInstruments\",\"Exchange\":\"{ExchangeName}\",\"Product\":\"{Product}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetServerInfo()
        {
            string message = "{\"MessageType\":\"GetServerInfo\"}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetExchanges()
        {
            string message = "{\"MessageType\":\"GetExchanges\"}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetInstrumentTypes()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetInstrumentTypes\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetProducts()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetProducts\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }

        static async Task GetExpiryDates()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetExpiryDates\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetOptionTypes()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetOptionTypes\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetStrikePrices()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetStrikePrices\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetLimitation()
        {
            string message = "{\"MessageType\":\"GetLimitation\"}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetMarketMessages()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetMarketMessages\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetExchangeMessages()
        {
            string ExchangeName = "MCX";
            string message = $"{{\"MessageType\":\"GetExchangeMessages\",\"Exchange\":\"{ExchangeName}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetLastQuoteOptionChain()
        {
            string Exchange = "NFO";
            string Product = "NIFTY";
            //string Expiry = "25APR2024"; 
            //string  OptionType = "CE";  
            //int  StrikePrice = 10000 ; 
            string message = $"{{\"MessageType\":\"GetLastQuoteOptionChain\",\"Exchange\":\"{Exchange}\",\"Product\":\"{Product}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetExchangeSnapshot()
        {
            string Exchange = "NFO";
            string Periodicity = "Minute";
            int Period = 1;
            //string InstrumentType = "FUTIDX" ; 
            //int From: 1567655100; 
            // int To: 0 ; 
            //string nonTraded = "false" ; 
            string message = $"{{\"MessageType\":\"GetExchangeSnapshot\",\"Exchange\":\"{Exchange}\",\"Period\":\"{Period}\",\"Periodicity\":\"{Periodicity}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetExchangeSnapshotAfterMarket()
        {
            string Exchange = "MCX";
            string Periodicity = "Minute";
            int Period = 1;
            //string InstrumentType = "FUTIDX";  
            int xDate = 1627291664;
            // int To: 0 ; 
            // string nonTraded = "false" ; 
            string message = $"{{\"MessageType\":\"GetExchangeSnapshotAfterMarket\",\"Exchange\":\"{Exchange}\",\"Period\":\"{Period}\",\"Periodicity\":\"{Periodicity}\",\"Date\":\"{xDate}\"}}";
            await SendMessageAsync(message);
        }


        static async Task GetLastQuoteOptionGreeks()
        {
            string Exchange = "NFO";
            int Token = 53937;
            string message = $"{{\"MessageType\":\"GetLastQuoteOptionGreeks\",\"Exchange\":\"{Exchange}\",\"Token\":\"{Token}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }


        static async Task GetLastQuoteArrayOptionGreeks()
        {
            string Exchange = "NFO";
            string Tokens = "[{\"Value\":\"53939\"},{\"Value\":\"53941\"}]";
            string message = $"{{\"MessageType\":\"GetLastQuoteArrayOptionGreeks\",\"Exchange\":\"{Exchange}\",\"Tokens\":\"{Tokens}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }

        static async Task GetLastQuoteOptionGreeksChain()
        {
            string Exchange = "NFO";
            string Product = "NIFTY";
            string message = $"{{\"MessageType\":\"GetLastQuoteOptionGreeksChain\",\"Exchange\":\"{Exchange}\",\"Product\":\"{Product}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task SubscribeOptionChain()
        {

            string Exchange = "NFO";
            string Product = "NIFTY";
		    int StrikePrice= 24000;
            string Expiry = "08AUG2024";
            //string OptionType="PE";
            int Depth = 5;
            string Unsubscribe = "false";
            string message = $"{{\"MessageType\":\"SubscribeOptionChain\",\"Exchange\":\"{Exchange}\",\"Product\":\"{Product}\",\"StrikePrice\":{StrikePrice},\"Expiry\":\"{Expiry}\",\"Depth\":{Depth},\"Unsubscribe\":\"{Unsubscribe}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);


        }
        static async Task SubscribeRealtimeGreeks()
        {
            string Exchange = "NFO";
            int Token = 53937;
            string message = $"{{\"MessageType\":\"SubscribeRealtimeGreeks\",\"Exchange\":\"{Exchange}\",\"Token\":\"{Token}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task SubscribeSnapshotGreeks()
        {
            string exchangeName = "NFO";
            string InstrumentIdentifier = "NIFTY28OCT2525000CE";
            string Unsubscribe = "false";
            string periodicity = "MINUTE";
            int period = 1;
            string message = $"{{\"MessageType\":\"SubscribeSnapshotGreeks\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{InstrumentIdentifier}\",\"Periodicity\":\"{periodicity}\",\"Period\":{period},\"Unsubscribe\":\"{Unsubscribe}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetSnapshotGreeks()
        {
            string exchangeName = "NFO";
            string instIdentifier = "[{\"Value\":\"NIFTY28OCT2525000CE\"},{\"Value\":\"BANKNIFTY28OCT2585000CE\"}]";
            string periodicity = "MINUTE";
            int period = 1;
            string isShortIdentifier = "false";
            string message = $"{{\"MessageType\":\"GetSnapshotGreeks\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifiers\":{instIdentifier},\"Periodicity\":\"{periodicity}\",\"Period\":{period},\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task SubscribeOptionChainGreeks()
        { 
            string Exchange = "NFO";
            string Product = "NIFTY";
            int StrikePrice = 24000;
            string Expiry = "08AUG2024";
            //string OptionType="PE";
            int Depth = 5;
            string Unsubscribe = "false";
            string message = $"{{\"MessageType\":\"SubscribeOptionChainGreeks\",\"Exchange\":\"{Exchange}\",\"Product\":\"{Product}\",\"StrikePrice\":{StrikePrice},\"Expiry\":\"{Expiry}\",\"Depth\":{Depth},\"Unsubscribe\":\"{Unsubscribe}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);


        }
        static async Task SubscribeTopGainersLosers()
        {
            string Exchange = "NFO";
            int Count = 5;
            string Unsubscribe = "false";
            string message = $"{{\"MessageType\":\"SubscribeTopGainersLosers\",\"Exchange\":\"{Exchange}\",\"Count\":\"{Count}\",\"Unsubscribe\":\"{Unsubscribe}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetTopGainersLosers()
        {
            string Exchange = "NFO";
            int Count = 5;
            string message = $"{{\"MessageType\":\"GetTopGainersLosers\",\"Exchange\":\"{Exchange}\",\"Count\":\"{Count}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetVolumeShockers()
        {
            string Exchange = "NFO";
            int Count = 5;
            string Series = "EQ";
            string message = $"{{\"MessageType\":\"GetVolumeShockers\",\"Exchange\":\"{Exchange}\",\"Count\":\"{Count}\",\"Series\":\"{Series}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }
        static async Task GetHistoryGreeks()
        {
            string exchangeName = "NFO";
            string instIdentifier = "NIFTY12SEP2425200CE";
            string periodicity = "MINUTE";
            int period = 1;
            // int  From = 1615919400;
            // int  To = 1621171693 ;
            int max = 10;
            string userTag = "User1";
            string isShortIdentifier = "true";
            string message = $"{{\"MessageType\":\"GetHistoryGreeks\",\"Exchange\":\"{exchangeName}\",\"InstrumentIdentifier\":\"{instIdentifier}\",\"Periodicity\":\"{periodicity}\",\"Period\":{period},\"Max\":{max},\"UserTag\":\"{userTag}\",\"isShortIdentifier\":\"{isShortIdentifier}\"}}";
            Console.WriteLine("Sending message: " + message);
            await SendMessageAsync(message);
        }





        static async Task SendMessageAsync(string message)
        {
            var buffer = Encoding.UTF8.GetBytes(message);
            await ws.SendAsync(new ArraySegment<byte>(buffer), WebSocketMessageType.Text, true, CancellationToken.None);
        }

        
        static async Task ReceiveMessage()
        {
            try
            {
                var buffer = new byte[1024 * 4];
                var accumulatedData = new StringBuilder();  
                WebSocketReceiveResult result;

                do
                {
                    result = await ws.ReceiveAsync(new ArraySegment<byte>(buffer), CancellationToken.None);

                    if (result.MessageType == WebSocketMessageType.Text)
                    {
                        string receivedData = Encoding.UTF8.GetString(buffer, 0, result.Count);
                        accumulatedData.Append(receivedData); 

                       
                        if (result.EndOfMessage)
                        {
                            string message = accumulatedData.ToString();  
                            HandleMessage(message);  
                            accumulatedData.Clear(); 
                        }
                    }
                }
                while (!result.CloseStatus.HasValue);
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
        }

        static void HandleMessage(string message)
        {
            try
            {
                var result_json = JsonConvert.DeserializeObject<dynamic>(message);

                if (result_json?.MessageType != "Echo")
                {
                    Console.WriteLine("Received message: " + message);

                    if (result_json?.MessageType == "AllowServerOSRunningResult")
                    {
                        Console.WriteLine("Authentication successful, subscribing to realtime data...");
                        CallMethode();
                    }

                    //ResetTimeoutTimer();
                }
            }
            catch (JsonException ex)
            {
                Console.WriteLine($"Error deserializing JSON message: {ex.Message}");
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred while handling the message: {ex.Message}");
            }
        }

        static void CallMethode()
        {
            SubscribeRealtime().Wait();
            //SubscribeSnapshot().Wait();
            //GetLastQuote().Wait();
            //GetLastQuoteShort().Wait();
            //GetLastQuoteShortWithClose().Wait();
            //GetLastQuoteArray().Wait();
            //GetLastQuoteArrayShort().Wait();
            //GetLastQuoteArrayShortWithClose().Wait();
            //GetSnapshot().Wait();
            //GetHistory().Wait();
            //GetInstrumentsOnSearch().Wait();
            //GetInstruments().Wait();
            //GetServerInfo().Wait();
            //GetExchanges().Wait();
            //GetInstrumentTypes().Wait();
            //GetProducts().Wait();
            //GetExpiryDates().Wait();
            //GetOptionTypes().Wait();
            //GetStrikePrices().Wait();
            //GetLimitation().Wait();
            //GetMarketMessages().Wait();
            //GetExchangeMessages().Wait();
            //GetLastQuoteOptionChain().Wait();
            //GetExchangeSnapshot().Wait();
            //GetExchangeSnapshotAfterMarket().Wait();
            //GetLastQuoteOptionGreeks().Wait();
            //GetLastQuoteArrayOptionGreeks().Wait();
            //GetLastQuoteOptionGreeksChain().Wait();
            //SubscribeOptionChain().Wait();
            //SubscribeRealtimeGreeks().Wait();
            //SubscribeSnapshotGreeks().Wait();
            //GetSnapshotGreeks().Wait();
            //SubscribeOptionChainGreeks().Wait();
            //SubscribeTopGainersLosers().Wait();
            //GetTopGainersLosers().Wait();
            GetVolumeShockers().Wait();
            //GetHistoryGreeks().Wait();


        }
        //static void ResetTimeoutTimer()
        //{
        //    timeoutTimer?.Change(TimeSpan.FromSeconds(300), TimeSpan.FromMilliseconds(-1));
        //}

        static void TimeoutAction(object state)
        {
            //Console.WriteLine("Timeout occurred after 300 seconds of only "Echo"messages.");
            ws.CloseAsync(WebSocketCloseStatus.NormalClosure, "Timeout", CancellationToken.None).Wait();
        }

        static async Task Run()
        {
            //timeoutTimer = new Timer(TimeoutAction, null, TimeSpan.FromSeconds(300), TimeSpan.FromMilliseconds(-1));
            await ws.ConnectAsync(new Uri(endpoint), CancellationToken.None);
            await Authenticate();
            await ReceiveMessage(); // This method now waits for a close message
        }

        static void Main(string[] args)
        {
            Run().GetAwaiter().GetResult();
        }
    }
}
